package lrs;

public abstract class ALazyEval
{
 /**
  * Performs lazy evaluation to compute the next LRStruct when needed.
  */
 public abstract LRStruct nextLRS();

 /**
  * Factory method to correctly  create the lazy list with this ILazyEval as the strategy for lazy evaluation.
  */
 public abstract LRStruct makeLRS();

  protected LRStruct makeLazyLRS(Object value)
  {
    LRStruct lrs = new LRStruct();
    lrs.setHead(new LazyNonNullState(value, this));
    return lrs;
  }

} 